--[[http://pastie.org/pastes/1519794/]]

local Player = ...
assert(Player,"Must pass in a player, dingus");

local paneCategoryValues = {
	{ Category = 'RadarCategory_TapsAndHolds'},
	{ Category = 'RadarCategory_Lifts'},
	{ Category = 'RadarCategory_Rolls'},
	{ Category = 'RadarCategory_Hands'},
	{ Category = 'RadarCategory_Mines'},
	{ Category = 'RadarCategory_Holds'},
	{ Category = 'RadarCategory_Jumps'},

};

local rb = Def.ActorFrame{
	Name="PaneDisplay"..Player;
	BeginCommand=function(self)
		self:visible(GAMESTATE:IsHumanPlayer(Player));
	end;
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == Player then
			self:visible(true);
		end;
	end;
	PlayerUnjoinedMessageCommand=function(self,param)
		if param.Player == Player then
			self:visible(false);
		end;
	end;
};

local yOffset = 16;	-- vertical offset between rows
local rv; -- for storing the RadarValues.

local Selection; -- either song or course.
local bIsCourseMode = GAMESTATE:IsCourseMode();
local StepsOrTrail;

for idx, cat in pairs(paneCategoryValues) do
	local paneCategory = cat.Category;	
	rb[#rb+1] = Def.ActorFrame{

		LoadFont("PaneDisplay text")..{
			InitCommand=cmd(horizalign,right;diffusealpha,0;sleep,0.7;zoom,0.75;maxwidth,80;sleep,idx/10;shadowlength,0;queuecommand,"Set");
			SetCommand=function(self)
				self:x(0);
				self:y(0);

			if idx-1 >= 1 then
				self:y(14);
				self:x(math.abs((idx-1)*40)-1);
			else
				self:x(math.abs(idx-7)*40);
			end;

			local value = 0;
				self:diffuse(color("1,1,1,0.5"));
				if bIsCourseMode then
					Selection = GAMESTATE:GetCurrentCourse();
					StepsOrTrail = GAMESTATE:GetCurrentTrail(Player);
				else
					Selection = GAMESTATE:GetCurrentSong();
					StepsOrTrail = GAMESTATE:GetCurrentSteps(Player);
				end;

				if not Selection then value = 0;
				else
					-- we have a selection.
					-- Make sure there's something to grab values from.
					if not StepsOrTrail then value = 0;
					else
						rv = StepsOrTrail:GetRadarValues(Player);
						value = rv:GetValue(paneCategory);
						if value == 0 then
							self:diffusealpha(0.5);
						elseif value == "?" then
							self:diffusealpha(0.5);
						else
							self:diffusealpha(1);
						end;
					end;
				end;
				value = value < 0 and "?" or value
				self:settext( value );
				self:diffuse( PaneValueToColor(paneCategory,value) )
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

			CurrentStepsP1ChangedMessageCommand=function(self)
			if Player == PLAYER_1 then 
				self:playcommand("Set"); end;
			end;
			CurrentTrailP1ChangedMessageCommand=function(self)
			if Player == PLAYER_1 then
				self:playcommand("Set"); end;
			end;
			CurrentStepsP2ChangedMessageCommand=function(self)
			if Player == PLAYER_2 then
				self:playcommand("Set"); end;
			end;
			CurrentTrailP2ChangedMessageCommand=function(self)
			if Player == PLAYER_2 then
				self:playcommand("Set"); end;
			end;
		};
	};
end;

return rb;